// // // // // // // // // // // // // // // // // // // //
//	
//	Simple Reflex Agent
//	
//	created Apr/14/98 by Andreas Warnke
//	last mod Mai/17/98 by Andreas Warnke
//	



// // // // // // // // // // // // // // // // // // // //
//	
//	#include
//

#include <Be.h>
#include "ConnectionData.h"
#include "Sensor.h"
#include "Effector.h"
#include "SimpleReflexAgent.h"
#include "GlobalVariables.h"
#include "Map.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	Constructor
//

SimpleReflexAgent :: SimpleReflexAgent () : BLooper ( "Simple Reflex Agent" )
{
	//	Nothing to do.
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Destructor
//

SimpleReflexAgent :: ~SimpleReflexAgent ()
{
	//	Nothing to do.
};



// // // // // // // // // // // // // // // // // // // //
//	
//	MessageReceived
//

void SimpleReflexAgent :: MessageReceived ( BMessage * inMessage )
{
	if ( inMessage -> what == eLoginButtonPressed )
		//	The User pressed the Login-Button.
		//	Login:
		Login (
			inMessage -> FindString ( "Name" ),
			inMessage -> FindString ( "Password" ),
			"" );
	else
		//	don't know what to do:
		Sensor :: MessageReceived ( inMessage );
};



// // // // // // // // // // // // // // // // // // // //
//	
//	GetEnvironment
//	This function extracts the Types of the 6 fields next to
//	the map-position ( inX, inY ) from the inMessage.
//

void SimpleReflexAgent :: GetEnvironment (
	int inX,
	int inY,
	BMessage * inMessage,
	unsigned int & outFieldAt1, 	//	upper right
	unsigned int & outFieldAt3, 	//	right
	unsigned int & outFieldAt5, 	//	lower right
	unsigned int & outFieldAt7, 	//	lower left
	unsigned int & outFieldAt9, 	//	left
	unsigned int & outFieldAt11 )	//	upper left
{
	//	Set 6 Fields around current position to
	//	default values:
	outFieldAt1 = eUndiscovered;
	outFieldAt3 = eUndiscovered;
	outFieldAt5 = eUndiscovered;
	outFieldAt7 = eUndiscovered;
	outFieldAt9 = eUndiscovered;
	outFieldAt11 = eUndiscovered;
			
	//	Get these 6 fields from message:
	unsigned int sFieldIndex = 0;
	BMessage sField;
	while ( inMessage -> FindMessage ( "Field", sFieldIndex, & sField ) >= B_NO_ERROR )
	{
		unsigned int sFieldType = sField . FindInt32 ( "Type" );
		int sFieldX = sField . FindInt32 ( "XPos" );
		int sFieldY = sField . FindInt32 ( "YPos" );
		if ( sFieldY == inY - 1 )
		{
			//	The field is in the row above the object.
			if ( sFieldX == inX + IsShiftRight ( inY ) )
				outFieldAt1 = sFieldType;
			if ( sFieldX == inX - 1 + IsShiftRight ( inY ) )
				outFieldAt11 = sFieldType;
		};
		if ( sFieldY == inY )
		{
			//	The field is in the same row as the object.
			if ( sFieldX == inX + 1 )
				outFieldAt3 = sFieldType;
			if ( sFieldX == inX - 1 )
				outFieldAt9 = sFieldType;
		};
		if ( sFieldY == inY + 1 )
		{
			// The field is in the row above the object.
			if ( sFieldX == inX + IsShiftRight ( inY ) )
				outFieldAt5 = sFieldType;
			if ( sFieldX == inX - 1 + IsShiftRight ( inY ) )
				outFieldAt7 = sFieldType;
		};
		
		//	Check next field:
		sFieldIndex ++;
	};
	//	ready.
};



// // // // // // // // // // // // // // // // // // // //
//	
//	Look for Enemies
//	This function chooses a direction, where to go
//

bool SimpleReflexAgent :: LookForEnemies (
	int inX,
	int inY,
	BMessage * inMessage,
	int & outDir )
{
	//	Look for objects of other players:
	unsigned int sObjectIndex = 0;
	BMessage sObject;
	while ( inMessage -> FindMessage ( "Object", sObjectIndex, & sObject ) >= B_NO_ERROR )
	{
		if ( sObject . FindInt32 ( "Owner" ) != ThePlayerID )
		{
			//	This is an enemy.
			int sEnemyX = sObject . FindInt32 ( "XPos" );
			int sEnemyY = sObject . FindInt32 ( "YPos" );
			
			//	Get the Direction to the enemy:
			int sOldDistance = Distance ( inX, inY, sEnemyX, sEnemyY );
			int sNewDistance;
			int sNoInfinity = 100;
			do
			{
				outDir = Fate . GetLong ( 6 );
				int sTestStepX;
				int sTestStepY;
				MoveToDirection ( inX, inY, outDir, sTestStepX, sTestStepY );
				sNewDistance = Distance ( sTestStepX, sTestStepY, sEnemyX, sEnemyY );
				sNoInfinity --;
			}
			while ( ( sOldDistance <= sNewDistance ) && ( sNoInfinity > 0 ) );
			
			//	enemy found:
			return true;
		};
		
		//	Next object-message:
		sObjectIndex ++;
	};
	
	//	no enemies found:
	return false;
};



// // // // // // // // // // // // // // // // // // // //
//	
//	StatusMessageReceived
//

void SimpleReflexAgent :: StatusMessageReceived ( BMessage * inMessage )
{	
	//	Call standard Method:
	Sensor :: StatusMessageReceived ( inMessage );
	
	//	Determine, if there is enough time to calculate a good move:
	unsigned int sMessagesWaiting = CountAllWaitingMessages ( Team () );
	if ( sMessagesWaiting > B_LOOPER_PORT_DEFAULT_CAPACITY / 3 )
		//	Timeout:
		return;
	bool sHurry = ( sMessagesWaiting > 5 );
	
	//	Look for armies with complete sensor data:
	unsigned int sObjectIndex = 0;
	BMessage sObject;
	while ( inMessage -> FindMessage ( "Object", sObjectIndex, & sObject ) >= B_NO_ERROR )
	{
		if ( sObject . FindBool ( "SensorData" )
			&& ( sObject . FindInt32 ( "Type" ) == eArmy )
			&& ( sObject . FindInt32 ( "Owner" ) == ThePlayerID ) )
		{
			//	This Object has complete sensor data, is an army and belongs to me.
			//	Save object's position and ID:
			int sXPos = sObject . FindInt32 ( "XPos" );
			int sYPos = sObject . FindInt32 ( "YPos" );
			unsigned int sID = sObject . FindInt32 ( "ID" );
		
			//	Define 6 Fields around object's position:
			unsigned int EnvironmentField [6];
			
			//	Get these 6 fields from message:
			GetEnvironment (
				sXPos,
				sYPos,
				inMessage,
				EnvironmentField [0],
				EnvironmentField [1],
				EnvironmentField [2],
				EnvironmentField [3],
				EnvironmentField [4],
				EnvironmentField [5] );
				
			//	While no action chosen repeat:
			bool sObjectMoved = false;
			while ( ! sObjectMoved )
			{
				//	Try to make a move.
				//	Choose Direction:
				int sDir = Fate . GetLong ( 6 );
				if ( ( ! sHurry ) && ( Fate . GetLong ( 4 ) != 0 ) )
				{
					//	Look for a good move:
					int sHintDir;
					if ( LookForEnemies ( sXPos, sYPos, inMessage, sHintDir ) )
						sDir = sHintDir ;
				};
				//	Make step:
				if ( CanWalk ( EnvironmentField [ sDir ] ) )
				{
					//	Move is valid.
					//	So - make the step:
					int sToX;
					int sToY;
					MoveToDirection ( sXPos, sYPos, sDir, sToX, sToY );
					Move ( sID, sToX, sToY );
					sObjectMoved = true;
				};
			};
			
	 	};
		sObjectIndex ++;
	};
};



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //